/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.recipe;

import com.github.ysbbbbbb.kaleidoscopecookery.block.entity.StockpotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.RecipeMatcher;

public class StockpotRecipe
implements Recipe<StockpotBlockEntity> {
    public static final int RECIPES_SIZE = 9;
    private final ResourceLocation id;
    private final int time;
    private final NonNullList<Ingredient> ingredients;
    @Nullable
    private final EntityType<?> inputEntityType;
    private final ItemStack result;
    private final Fluid soupBase;
    private final ResourceLocation cookingTexture;
    private final ResourceLocation finishedTexture;
    private final int cookingBubbleColor;
    private final int finishedBubbleColor;

    public StockpotRecipe(ResourceLocation id, List<Ingredient> ingredients, @Nullable EntityType<?> inputEntityType, ItemStack result, int time, Fluid soupBase, ResourceLocation cookingTexture, ResourceLocation finishedTexture, int cookingBubbleColor, int finishedBubbleColor) {
        this.id = id;
        this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])this.fillInputs(ingredients));
        this.inputEntityType = inputEntityType;
        this.result = result;
        this.time = time;
        this.soupBase = soupBase;
        this.cookingTexture = cookingTexture;
        this.finishedTexture = finishedTexture;
        this.cookingBubbleColor = cookingBubbleColor;
        this.finishedBubbleColor = finishedBubbleColor;
    }

    public boolean matches(StockpotBlockEntity container, Level level) {
        return container.getSoupBase().equals(this.soupBase) && Objects.equals(container.getInputEntityType(), this.inputEntityType) && RecipeMatcher.findMatches(container.getItems(), this.ingredients) != null;
    }

    public ItemStack assemble(StockpotBlockEntity container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.STOCKPOT_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.STOCKPOT_RECIPE;
    }

    public boolean m_5598_() {
        return true;
    }

    public int getTime() {
        return this.time;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Fluid getSoupBase() {
        return this.soupBase;
    }

    public ResourceLocation getCookingTexture() {
        return this.cookingTexture;
    }

    public ResourceLocation getFinishedTexture() {
        return this.finishedTexture;
    }

    @Nullable
    public EntityType<?> getInputEntityType() {
        return this.inputEntityType;
    }

    public int getCookingBubbleColor() {
        return this.cookingBubbleColor;
    }

    public int getFinishedBubbleColor() {
        return this.finishedBubbleColor;
    }

    private Ingredient[] fillInputs(List<Ingredient> inputs) {
        Ingredient[] newInputs = new Ingredient[9];
        for (int i = 0; i < 9; ++i) {
            newInputs[i] = i < inputs.size() ? inputs.get(i) : Ingredient.f_43901_;
        }
        return newInputs;
    }
}

