/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.init.registry;

import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.item.BowlFoodBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="kaleidoscope_cookery")
public class CommonRegistry {
    @SubscribeEvent
    public static void onSetupEvent(FMLCommonSetupEvent event) {
        CommonRegistry.addComposter();
    }

    @SubscribeEvent
    public static void onBlockRegistryEvent(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCKS)) {
            FoodBiteRegistry.FOOD_DATA_MAP.forEach((resourceLocation, data) -> event.register(ForgeRegistries.Keys.BLOCKS, resourceLocation, () -> new FoodBiteBlock(data.blockFood(), data.maxBites(), data.animateTick())));
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
            FoodBiteRegistry.FOOD_DATA_MAP.forEach((resourceLocation, data) -> {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
                if (block != null) {
                    event.register(ForgeRegistries.Keys.ITEMS, resourceLocation, () -> new BowlFoodBlockItem(block, data.itemFood()));
                }
            });
        }
    }

    private static void addComposter() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.TOMATO_SEED.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CHILI_SEED.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.LETTUCE_SEED.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RICE_SEED.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.TOMATO.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RED_CHILI.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.GREEN_CHILI.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.LETTUCE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.RICE_PANICLE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CATERPILLAR.get()), 1.0f);
    }
}

