/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.model;

import com.github.ysbbbbbb.kaleidoscopecookery.block.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.StoveBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.RiceCropBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockStateGenerator
extends BlockStateProvider {
    public BlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "kaleidoscope_cookery", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.horizontalBlock((Block)ModBlocks.STOVE.get(), blockState -> {
            if (((Boolean)blockState.m_61143_((Property)StoveBlock.LIT)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/stove_lit"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/stove"));
        });
        this.horizontalBlock((Block)ModBlocks.POT.get(), blockState -> {
            if (((Boolean)blockState.m_61143_((Property)PotBlock.HAS_OIL)).booleanValue() && ((Boolean)blockState.m_61143_((Property)PotBlock.SHOW_OIL)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/pot_has_oil"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/pot"));
        });
        this.horizontalBlock((Block)ModBlocks.STOCKPOT.get(), blockState -> {
            if (((Boolean)blockState.m_61143_((Property)StockpotBlock.HAS_LID)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot_has_lid"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot"));
        });
        FoodBiteRegistry.FOOD_DATA_MAP.forEach((key, value) -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
            if (block != null) {
                this.addFoodBiteBlock(block, (ResourceLocation)key);
            }
        });
        this.horizontalBlock((Block)ModBlocks.FRUIT_BASKET.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/fruit_basket")));
        this.horizontalBlock((Block)ModBlocks.CHOPPING_BOARD.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/chopping_board")));
        this.cookStool(ModBlocks.COOK_STOOL_OAK, "oak");
        this.cookStool(ModBlocks.COOK_STOOL_SPRUCE, "spruce");
        this.cookStool(ModBlocks.COOK_STOOL_ACACIA, "acacia");
        this.cookStool(ModBlocks.COOK_STOOL_BAMBOO, "bamboo");
        this.cookStool(ModBlocks.COOK_STOOL_BIRCH, "birch");
        this.cookStool(ModBlocks.COOK_STOOL_CHERRY, "cherry");
        this.cookStool(ModBlocks.COOK_STOOL_CRIMSON, "crimson");
        this.cookStool(ModBlocks.COOK_STOOL_DARK_OAK, "dark_oak");
        this.cookStool(ModBlocks.COOK_STOOL_JUNGLE, "jungle");
        this.cookStool(ModBlocks.COOK_STOOL_MANGROVE, "mangrove");
        this.cookStool(ModBlocks.COOK_STOOL_WARPED, "warped");
        this.simpleBlock((Block)ModBlocks.OIL_BLOCK.get());
        this.crop(ModBlocks.TOMATO_CROP, "tomato");
        this.crop(ModBlocks.CHILI_CROP, "chili");
        this.crop(ModBlocks.LETTUCE_CROP, "lettuce");
        this.riceCrop();
    }

    public void crop(RegistryObject<Block> block, String name) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)CropBlock.f_52244_);
            ResourceLocation file = this.modLoc("block/crop/%s/stage%d".formatted(name, age));
            return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(file)).build();
        });
    }

    public void riceCrop() {
        this.getVariantBuilder((Block)ModBlocks.RICE_CROP.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)CropBlock.f_52244_);
            int location = (Integer)state.m_61143_((Property)RiceCropBlock.LOCATION);
            ResourceLocation file = location == 0 ? this.modLoc("block/crop/rice/stage%d_down".formatted(age)) : (location == 1 ? this.modLoc("block/crop/rice/stage%d_middle".formatted(age)) : this.modLoc("block/crop/rice/stage%d_up".formatted(age)));
            return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(file)).build();
        });
    }

    public void cookStool(RegistryObject<Block> block, String name) {
        this.horizontalBlock((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/cook_stool/" + name)));
    }

    public void addFoodBiteBlock(Block block, ResourceLocation id) {
        this.horizontalBlock(block, blockState -> {
            Block patt5530$temp = blockState.m_60734_();
            if (!(patt5530$temp instanceof FoodBiteBlock)) {
                throw new IllegalArgumentException("Block must be an instance of FoodBiteBlock");
            }
            FoodBiteBlock foodBiteBlock = (FoodBiteBlock)patt5530$temp;
            int bites = (Integer)blockState.m_61143_((Property)foodBiteBlock.getBites());
            ResourceLocation model = new ResourceLocation(id.m_135827_(), "block/food/%s/%s_%d".formatted(id.m_135815_(), id.m_135815_(), bites));
            return new ModelFile.UncheckedModelFile(model);
        });
    }
}

