/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.model;

import java.util.stream.IntStream;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockModelGenerator
extends BlockModelProvider {
    public BlockModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "kaleidoscope_cookery", existingFileHelper);
    }

    protected void registerModels() {
        ResourceLocation stoveSide = this.modLoc("block/stove_side");
        ResourceLocation stoveTop = this.modLoc("block/stove_top");
        ResourceLocation stoveTopLit = this.modLoc("block/stove_top_lit");
        ((BlockModelBuilder)this.cube("stove", stoveTop, stoveTop, this.modLoc("block/stove_front"), stoveSide, stoveSide, stoveSide)).texture("particle", stoveSide);
        ((BlockModelBuilder)this.cube("stove_lit", stoveTopLit, stoveTopLit, this.modLoc("block/stove_front_lit"), stoveSide, stoveSide, stoveSide)).texture("particle", stoveSide);
        this.cookStool("oak");
        this.cookStool("spruce");
        this.cookStool("acacia");
        this.cookStool("bamboo");
        this.cookStool("birch");
        this.cookStool("cherry");
        this.cookStool("crimson");
        this.cookStool("dark_oak");
        this.cookStool("jungle");
        this.cookStool("mangrove");
        this.cookStool("warped");
        this.crop("tomato", 8);
        this.crop("chili", 8);
        this.crop("lettuce", 8);
        this.riceCrop();
    }

    public void cookStool(String name) {
        String path = "block/cook_stool/" + name;
        ((BlockModelBuilder)this.withExistingParent(path, this.modLoc("block/cook_stool/cook_stool"))).texture("particle", this.modLoc(path));
    }

    public void crop(String name, int stage) {
        IntStream.range(0, stage).forEach(i -> {
            String id = "block/crop/%s/stage%d".formatted(name, i);
            ((BlockModelBuilder)this.cross(id, this.modLoc(id))).renderType("cutout");
        });
    }

    public void riceCrop() {
        IntStream.range(0, 8).forEach(i -> {
            String down = "block/crop/rice/stage%d_down".formatted(i);
            String middle = "block/crop/rice/stage%d_middle".formatted(i);
            String up = "block/crop/rice/stage%d_up".formatted(i);
            ((BlockModelBuilder)this.cross(down, this.modLoc(down))).renderType("cutout");
            ((BlockModelBuilder)this.cross(middle, this.modLoc(middle))).renderType("cutout");
            ((BlockModelBuilder)this.cross(up, this.modLoc(up))).renderType("cutout");
        });
    }
}

