/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.entity;

import com.github.ysbbbbbb.kaleidoscopecookery.block.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.client.particle.StockpotParticleOptions;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagItem;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import com.github.ysbbbbbb.kaleidoscopecookery.mixin.MobBucketItemAccessor;
import com.github.ysbbbbbb.kaleidoscopecookery.recipe.serializer.StockpotRecipeSerializer;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class StockpotBlockEntity
extends BlockEntity
implements Container {
    public static final int PUT_SOUP_BASE = 0;
    public static final int PUT_INGREDIENT = 1;
    public static final int COOKING = 2;
    public static final int FINISHED = 3;
    public static final int MAX_TAKEOUT_COUNT = 9;
    private static final String INPUT_ENTITY_TYPE = "InputEntityType";
    private static final String RESULT = "Result";
    private static final String STATUS = "Status";
    private static final String SOUP_BASE = "SoupBase";
    private static final String CURRENT_TICK = "CurrentTick";
    private static final String TAKEOUT_COUNT = "TakeoutCount";
    private static final String COOKING_TEXTURE = "CookingTexture";
    private static final String FINISHED_TEXTURE = "FinishedTexture";
    private static final String SOUP_BASE_BUBBLE_COLOR = "SoupBaseBubbleColor";
    private static final String COOKING_BUBBLE_COLOR = "CookingBubbleColor";
    private static final String FINISHED_BUBBLE_COLOR = "FinishedBubbleColor";
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private Item inputEntityType = null;
    private ItemStack result = ItemStack.f_41583_;
    private int status = 0;
    private Fluid soupBase = Fluids.f_76191_;
    private int currentTick = -1;
    private int takeoutCount = 0;
    @Nullable
    private ResourceLocation cookingTexture;
    @Nullable
    private ResourceLocation finishedTexture;
    private int soupBaseBubbleColor = 0xFFFFFF;
    private int cookingBubbleColor = 16772291;
    private int finishedBubbleColor = 16034443;
    public Entity renderEntity = null;

    public StockpotBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlocks.STOCKPOT_BE.get(), pPos, pBlockState);
    }

    public void clientTick() {
        if (this.renderEntity != null) {
            ++this.renderEntity.f_19797_;
        }
    }

    public void tick() {
        Level color2;
        if (this.f_58857_ == null) {
            return;
        }
        BlockState belowState = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        if (!belowState.m_61138_((Property)BlockStateProperties.f_61443_) || !((Boolean)belowState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            return;
        }
        Boolean hasLid = (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)StockpotBlock.HAS_LID);
        if (this.status != 0 && this.f_58857_.m_46467_() % 15L == 0L) {
            float volume = hasLid != false ? 0.075f : 0.2f;
            float pitch = hasLid != false ? 0.1f + this.f_58857_.f_46441_.m_188501_() * 0.05f : 1.0f + this.f_58857_.f_46441_.m_188501_() * 0.1f;
            this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)ModSounds.BLOCK_STOCKPOT.get(), SoundSource.BLOCKS, volume, pitch);
        }
        if (!hasLid.booleanValue()) {
            Level pitch;
            if (this.status != 0 && (pitch = this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pitch;
                if (this.f_58857_.f_46441_.m_188501_() < 0.25f) {
                    int color2 = this.status == 2 ? this.cookingBubbleColor : (this.status == 3 ? this.finishedBubbleColor : this.soupBaseBubbleColor);
                    serverLevel.m_8767_((ParticleOptions)new StockpotParticleOptions(Vec3.m_82501_((int)color2).m_252839_(), 1.0f), (double)this.f_58858_.m_123341_() + 0.25 + (double)(this.f_58857_.f_46441_.m_188501_() * 0.5f), (double)this.f_58858_.m_123342_() + 0.375, (double)this.f_58858_.m_123343_() + 0.25 + (double)(this.f_58857_.f_46441_.m_188501_() * 0.5f), 2, ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * (double)0.1f, 0.0, ((double)this.f_58857_.f_46441_.m_188501_() - 0.5) * (double)0.1f, 0.0);
                }
            }
            return;
        }
        if (this.status != 0 && (color2 = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)color2;
            if (this.f_58857_.f_46441_.m_188501_() < 0.05f) {
                RandomSource random = serverLevel.f_46441_;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)this.f_58858_.m_123342_() + 0.375 + random.m_188500_() / 3.0, (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
        if (this.status == 1 && this.f_58857_.m_46467_() % 5L == 0L && !this.m_7983_()) {
            this.setRecipe(this.f_58857_);
            this.status = 2;
            this.refresh();
            return;
        }
        if (this.status == 2) {
            if (this.currentTick > 0) {
                --this.currentTick;
                return;
            }
            this.status = 3;
            this.inputEntityType = null;
            this.currentTick = -1;
            this.soupBase = Fluids.f_76191_;
            this.items.clear();
            this.refresh();
        }
    }

    public void onLitClick(Player player) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
        Boolean hasLid = (Boolean)blockState.m_61143_((Property)StockpotBlock.HAS_LID);
        ItemStack mainHandItem = player.m_21205_();
        if (!hasLid.booleanValue() && mainHandItem.m_150930_((Item)ModItems.STOCKPOT_LID.get())) {
            mainHandItem.m_41774_(1);
            this.m_6596_();
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)StockpotBlock.HAS_LID, (Comparable)Boolean.valueOf(true)));
            player.m_5496_(SoundEvents.f_12028_, 0.5f, 0.5f);
            return;
        }
        if (hasLid.booleanValue()) {
            ItemStack lid = ((Item)ModItems.STOCKPOT_LID.get()).m_7968_();
            if (mainHandItem.m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, lid);
            } else {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)lid);
            }
            this.m_6596_();
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)StockpotBlock.HAS_LID, (Comparable)Boolean.valueOf(false)));
            player.m_5496_(SoundEvents.f_12025_, 0.5f, 0.5f);
        }
    }

    private void setRecipe(Level levelIn) {
        levelIn.m_7465_().m_44015_(ModRecipes.STOCKPOT_RECIPE, (Container)this, levelIn).ifPresentOrElse(recipe -> {
            this.result = recipe.assemble(this, levelIn.m_9598_());
            this.currentTick = recipe.getTime();
            this.cookingTexture = recipe.getCookingTexture();
            this.finishedTexture = recipe.getFinishedTexture();
            this.cookingBubbleColor = recipe.getCookingBubbleColor();
            this.finishedBubbleColor = recipe.getFinishedBubbleColor();
            this.takeoutCount = Math.min(this.result.m_41613_(), 9);
        }, () -> {
            this.result = Items.f_42718_.m_7968_();
            this.currentTick = 300;
            this.cookingTexture = StockpotRecipeSerializer.DEFAULT_COOKING_TEXTURE;
            this.finishedTexture = StockpotRecipeSerializer.DEFAULT_FINISHED_TEXTURE;
            this.cookingBubbleColor = 16772291;
            this.finishedBubbleColor = 16034443;
            this.takeoutCount = 1;
        });
    }

    public void onBucketClick(Player player) {
        if (this.f_58857_ == null || ((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)StockpotBlock.HAS_LID)).booleanValue()) {
            return;
        }
        ItemStack bucket = player.m_21205_();
        Item item = bucket.m_41720_();
        if (!(item instanceof BucketItem)) {
            return;
        }
        BucketItem bucketItem = (BucketItem)item;
        if (this.status == 0) {
            SoundEvent sound;
            MobBucketItemAccessor accessor;
            Fluid fluid = bucketItem.getFluid();
            if (fluid == Fluids.f_76191_) {
                return;
            }
            Item item2 = bucket.m_41720_();
            if (item2 instanceof MobBucketItemAccessor && (accessor = (MobBucketItemAccessor)item2).kaleidoscope$GetFishType() != null) {
                this.inputEntityType = bucketItem;
            }
            if ((sound = fluid.getFluidType().getSound((Entity)player, SoundActions.BUCKET_EMPTY)) != null) {
                this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            player.m_21008_(InteractionHand.MAIN_HAND, ItemUtils.m_41813_((ItemStack)bucket, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
            this.soupBase = fluid;
            this.status = 1;
            this.soupBaseBubbleColor = this.soupBase.m_205067_(FluidTags.f_13131_) ? 4159204 : (this.soupBase.m_205067_(FluidTags.f_13132_) ? 16750648 : 0xFFFFFF);
            this.refresh();
            return;
        }
        if (this.status == 1 && this.m_7983_() && this.soupBase != Fluids.f_76191_ && bucketItem.getFluid() == Fluids.f_76191_) {
            SoundEvent sound = this.soupBase.getFluidType().getSound((Entity)player, SoundActions.BUCKET_FILL);
            if (sound != null) {
                this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultBucket = new ItemStack((ItemLike)Objects.requireNonNullElseGet(this.inputEntityType, () -> this.soupBase.m_6859_()));
            player.m_21008_(InteractionHand.MAIN_HAND, ItemUtils.m_41813_((ItemStack)bucket, (Player)player, (ItemStack)resultBucket));
            this.inputEntityType = null;
            this.renderEntity = null;
            this.soupBase = Fluids.f_76191_;
            this.status = 0;
            this.refresh();
        }
    }

    public void onIngredientClick(Player player) {
        if (this.f_58857_ == null || ((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)StockpotBlock.HAS_LID)).booleanValue()) {
            return;
        }
        if (this.status == 1) {
            ItemStack mainHandItem = player.m_21205_();
            if (mainHandItem.m_41619_()) {
                for (int i = this.m_6643_() - 1; i >= 0; --i) {
                    if (this.m_8020_(i).m_41619_()) continue;
                    player.m_21008_(InteractionHand.MAIN_HAND, this.m_8020_(i).m_41777_());
                    this.f_58857_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                    this.m_7407_(i, 1);
                    this.refresh();
                    return;
                }
                return;
            }
            if (mainHandItem.m_41614_() || mainHandItem.m_204117_(TagItem.POT_INGREDIENT)) {
                for (int i = 0; i < this.m_6643_(); ++i) {
                    if (!this.m_8020_(i).m_41619_()) continue;
                    this.m_6836_(i, mainHandItem.m_41620_(1));
                    this.f_58857_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                    if (this.soupBase.getFluidType().getTemperature() > 500) {
                        player.m_6469_(this.f_58857_.m_269111_().m_269387_(), 1.0f);
                    }
                    this.refresh();
                    return;
                }
            }
        }
    }

    public void onBowlClick(Player player) {
        ItemStack bowl;
        if (this.f_58857_ == null || ((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)StockpotBlock.HAS_LID)).booleanValue()) {
            return;
        }
        if (this.status == 3 && this.takeoutCount > 0 && (bowl = player.m_21205_()).m_150930_(Items.f_42399_)) {
            ItemStack resultCopy = this.result.m_41777_();
            resultCopy.m_41764_(1);
            bowl.m_41774_(1);
            if (bowl.m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, resultCopy);
                this.f_58857_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            } else {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)resultCopy);
            }
            --this.takeoutCount;
            if (this.takeoutCount <= 0) {
                this.status = 0;
                this.inputEntityType = null;
                this.items.clear();
                this.result = ItemStack.f_41583_;
                this.soupBase = Fluids.f_76191_;
                this.cookingTexture = null;
                this.finishedTexture = null;
                this.soupBaseBubbleColor = 0xFFFFFF;
                this.cookingBubbleColor = 16772291;
                this.finishedBubbleColor = 16034443;
                this.currentTick = -1;
            }
            this.refresh();
        }
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        if (this.inputEntityType != null) {
            tag.m_128359_(INPUT_ENTITY_TYPE, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.inputEntityType)).toString());
        } else {
            tag.m_128473_(INPUT_ENTITY_TYPE);
        }
        tag.m_128365_(RESULT, (Tag)this.result.m_41739_(new CompoundTag()));
        tag.m_128405_(STATUS, this.status);
        tag.m_128359_(SOUP_BASE, Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.soupBase)).toString());
        tag.m_128405_(CURRENT_TICK, this.currentTick);
        tag.m_128405_(TAKEOUT_COUNT, this.takeoutCount);
        if (this.cookingTexture != null) {
            tag.m_128359_(COOKING_TEXTURE, this.cookingTexture.toString());
        }
        if (this.finishedTexture != null) {
            tag.m_128359_(FINISHED_TEXTURE, this.finishedTexture.toString());
        }
        tag.m_128405_(SOUP_BASE_BUBBLE_COLOR, this.soupBaseBubbleColor);
        tag.m_128405_(COOKING_BUBBLE_COLOR, this.cookingBubbleColor);
        tag.m_128405_(FINISHED_BUBBLE_COLOR, this.finishedBubbleColor);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.inputEntityType = tag.m_128441_(INPUT_ENTITY_TYPE) ? (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)tag.m_128461_(INPUT_ENTITY_TYPE))) : null;
        this.result = ItemStack.m_41712_((CompoundTag)tag.m_128469_(RESULT));
        this.status = tag.m_128451_(STATUS);
        this.soupBase = (Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)tag.m_128461_(SOUP_BASE)));
        this.currentTick = tag.m_128451_(CURRENT_TICK);
        this.takeoutCount = tag.m_128451_(TAKEOUT_COUNT);
        this.cookingTexture = tag.m_128441_(COOKING_TEXTURE) ? ResourceLocation.m_135820_((String)tag.m_128461_(COOKING_TEXTURE)) : null;
        this.finishedTexture = tag.m_128441_(FINISHED_TEXTURE) ? ResourceLocation.m_135820_((String)tag.m_128461_(FINISHED_TEXTURE)) : null;
        this.soupBaseBubbleColor = tag.m_128451_(SOUP_BASE_BUBBLE_COLOR);
        this.cookingBubbleColor = tag.m_128451_(COOKING_BUBBLE_COLOR);
        this.finishedBubbleColor = tag.m_128451_(FINISHED_BUBBLE_COLOR);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return 0 <= index && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.items, (int)pSlot);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        if (0 <= pIndex && pIndex < this.items.size()) {
            this.items.set(pIndex, (Object)pStack);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public Fluid getSoupBase() {
        return this.soupBase;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getStatus() {
        return this.status;
    }

    public int getTakeoutCount() {
        return this.takeoutCount;
    }

    @Nullable
    public ResourceLocation getCookingTexture() {
        return this.cookingTexture;
    }

    @Nullable
    public ResourceLocation getFinishedTexture() {
        return this.finishedTexture;
    }

    @Nullable
    public EntityType<?> getInputEntityType() {
        Item item = this.inputEntityType;
        if (item instanceof MobBucketItemAccessor) {
            MobBucketItemAccessor accessor = (MobBucketItemAccessor)item;
            return accessor.kaleidoscope$GetFishType();
        }
        return null;
    }
}

