/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.registries;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yuushya.registries.YuushyaRegistryConfig;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class YuushyaResourceReloadListener
extends SimpleJsonResourceReloadListener {
    public static final Map<String, JsonObject> YuushyaRawJsonBlockMap = new LinkedHashMap<String, JsonObject>();
    public static final Map<String, JsonObject> YuushyaRawJsonItemMap = new LinkedHashMap<String, JsonObject>();
    public static final Map<String, JsonObject> YuushyaRawJsonParticleMap = new LinkedHashMap<String, JsonObject>();

    public YuushyaResourceReloadListener() {
        super(GsonTools.NormalGSON, "register");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        map.forEach((fileResourceLocationString, json) -> {
            JsonArray block = json.getAsJsonObject().getAsJsonArray("block");
            JsonArray item = json.getAsJsonObject().getAsJsonArray("item");
            JsonArray particle = json.getAsJsonObject().getAsJsonArray("particle");
            if (block != null) {
                block.forEach(e -> YuushyaRawJsonBlockMap.put(e.getAsJsonObject().getAsJsonPrimitive("name").getAsString(), e.getAsJsonObject()));
            }
            if (item != null) {
                item.forEach(e -> YuushyaRawJsonItemMap.put(e.getAsJsonObject().getAsJsonPrimitive("name").getAsString(), e.getAsJsonObject()));
            }
            if (particle != null) {
                particle.forEach(e -> YuushyaRawJsonParticleMap.put(e.getAsJsonObject().getAsJsonPrimitive("name").getAsString(), e.getAsJsonObject()));
            }
        });
        YuushyaResourceReloadListener.writeRegistryConfig();
    }

    public static YuushyaRegistryData getYuushyaRegistryData() {
        JsonArray block = new JsonArray();
        YuushyaRawJsonBlockMap.values().forEach(arg_0 -> ((JsonArray)block).add(arg_0));
        JsonArray item = new JsonArray();
        YuushyaRawJsonItemMap.values().forEach(arg_0 -> ((JsonArray)item).add(arg_0));
        JsonArray particle = new JsonArray();
        YuushyaRawJsonParticleMap.values().forEach(arg_0 -> ((JsonArray)particle).add(arg_0));
        YuushyaRegistryConfig.mergeYuushyaRegistryBlockJson(block);
        JsonObject json = new JsonObject();
        json.add("block", (JsonElement)block);
        json.add("item", (JsonElement)item);
        json.add("particle", (JsonElement)particle);
        YuushyaRegistryData yuushyaRegistryData = (YuushyaRegistryData)GsonTools.NormalGSON.fromJson((JsonElement)json, YuushyaRegistryData.class);
        yuushyaRegistryData.version = YuushyaRegistryConfig.VERSION;
        return yuushyaRegistryData;
    }

    public static void writeRegistryConfig() {
        try {
            YuushyaRegistryConfig.CONFIG_FILE.getParentFile().mkdirs();
            YuushyaRegistryConfig.CONFIG_FILE.createNewFile();
            YuushyaRegistryData yuushyaRegistryData = YuushyaResourceReloadListener.getYuushyaRegistryData();
            String json = GsonTools.NormalGSON.toJson((Object)yuushyaRegistryData);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(YuushyaRegistryConfig.CONFIG_FILE), StandardCharsets.UTF_8));){
                writer.write(json);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

