/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.registries;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class YuushyaRegistryConfig {
    public static final Map<String, YuushyaRegistryData.Block> YuushyaRawBlockMap = new LinkedHashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Item> YuushyaRawItemMap = new LinkedHashMap<String, YuushyaRegistryData.Item>();
    public static final Map<String, YuushyaRegistryData.Particle> YuushyaRawParticleMap = new LinkedHashMap<String, YuushyaRegistryData.Particle>();
    public static final Map<String, YuushyaRegistryData.ItemGroup> YuushyaRawItemGroupMap = new LinkedHashMap<String, YuushyaRegistryData.ItemGroup>();
    public static final File CONFIG_FILE = Platform.getConfigFolder().resolve("com.yuushya/register.json").toFile();
    public static final String VERSION = Platform.getMod((String)"yuushya").getVersion();
    public static final InputStream InnerFileInputStream = YuushyaRegistryConfig.class.getResourceAsStream("/data/yuushya/register/inner.json");
    private static final Map<String, JsonObject> BlockClass = new HashMap<String, JsonObject>();

    public static void addResultToRawMap(YuushyaRegistryData from) {
        if (from.block != null) {
            from.block.forEach(e -> YuushyaRawBlockMap.put(e.name, (YuushyaRegistryData.Block)e));
        }
        if (from.item != null) {
            from.item.forEach(e -> YuushyaRawItemMap.put(e.name, (YuushyaRegistryData.Item)e));
        }
        if (from.particle != null) {
            from.particle.forEach(e -> YuushyaRawParticleMap.put(e.name, (YuushyaRegistryData.Particle)e));
        }
        if (from.itemGroup != null) {
            from.itemGroup.forEach(e -> YuushyaRawItemGroupMap.put(e.name, (YuushyaRegistryData.ItemGroup)e));
        }
    }

    @Deprecated
    public static void readRegistrySelf() {
        YuushyaRegistryData yuushyaData = YuushyaRegistryConfig.readRegistryInner(InnerFileInputStream);
        YuushyaRegistryConfig.addResultToRawMap(yuushyaData);
    }

    @Deprecated
    public static void readRegistryConfig() {
        if (!CONFIG_FILE.exists()) {
            YuushyaRegistryData yuushyaData = YuushyaRegistryConfig.readRegistryInner(InnerFileInputStream);
            YuushyaRegistryConfig.addResultToRawMap(yuushyaData);
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(CONFIG_FILE));){
            JsonElement configJson = JsonParser.parseReader((Reader)reader);
            YuushyaRegistryConfig.mergeYuushyaRegistryBlockClass(configJson);
            YuushyaRegistryData yuushyaRegistryData = (YuushyaRegistryData)GsonTools.NormalGSON.fromJson(configJson, YuushyaRegistryData.class);
            if (yuushyaRegistryData.version.equals(VERSION)) {
                YuushyaRegistryConfig.addResultToRawMap(yuushyaRegistryData);
            } else {
                YuushyaRegistryData yuushyaData = YuushyaRegistryConfig.readRegistryInner(InnerFileInputStream);
                YuushyaRegistryConfig.addResultToRawMap(yuushyaRegistryData);
                YuushyaRegistryConfig.addResultToRawMap(yuushyaData);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static YuushyaRegistryData readRegistryInner(InputStream innerFileInputStream) {
        if (innerFileInputStream != null) {
            YuushyaRegistryData yuushyaRegistryData;
            BufferedReader reader = new BufferedReader(new InputStreamReader(innerFileInputStream));
            try {
                YuushyaRegistryData yuushyaData;
                JsonElement innerJson = JsonParser.parseReader((Reader)reader);
                YuushyaRegistryConfig.mergeYuushyaRegistryBlockClass(innerJson);
                yuushyaRegistryData = yuushyaData = (YuushyaRegistryData)GsonTools.NormalGSON.fromJson(innerJson, YuushyaRegistryData.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return yuushyaRegistryData;
        }
        return new YuushyaRegistryData();
    }

    public static void mergeYuushyaRegistryBlockClass(JsonElement innerJson) {
        JsonElement jsonElement;
        JsonObject jsonObject;
        if (innerJson instanceof JsonObject && (jsonObject = (JsonObject)innerJson).has("block") && (jsonElement = jsonObject.get("block")) instanceof JsonArray) {
            JsonArray blockArray = (JsonArray)jsonElement;
            YuushyaRegistryConfig.mergeYuushyaRegistryBlockJson(blockArray);
        }
    }

    public static void mergeYuushyaRegistryBlockJson(JsonArray blockList) {
        blockList.forEach(block -> {
            JsonObject blockObject = block.getAsJsonObject();
            String classType = blockObject.get("class_type").getAsString();
            if ("class".equals(classType)) {
                BlockClass.put(blockObject.get("name").getAsString(), blockObject);
            } else if (BlockClass.containsKey(classType)) {
                try {
                    GsonTools.extendJsonObject(blockObject, GsonTools.ConflictStrategy.PREFER_FIRST_OBJ, BlockClass.get(classType));
                }
                catch (GsonTools.JsonObjectExtensionConflictException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

