/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.block;

import com.yuushya.block.AbstractYuushyaBlockType;
import com.yuushya.block.LineBlock;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.block.blockstate.PositionHorizonState;
import com.yuushya.block.blockstate.ShapeState;
import com.yuushya.block.blockstate.YuushyaBlockStates;
import com.yuushya.utils.YuushyaUtils;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LineCornerBlock
extends AbstractYuushyaBlockType {
    @Override
    public List<Property<?>> getBlockStateProperty() {
        return List.of(BlockStateProperties.f_61374_, YuushyaBlockStates.POS_HORIZON, YuushyaBlockStates.SHAPE);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        BlockState res = blockPlaceContext.m_43719_().m_122434_() == Direction.Axis.Y ? (BlockState)this.defaultBlockState().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_8125_()) : (BlockState)this.defaultBlockState().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_43719_().m_122424_());
        return (BlockState)((BlockState)res.m_61124_(YuushyaBlockStates.POS_HORIZON, (Comparable)((Object)LineCornerBlock.getPositionOfFaceWithCorner(res, (LevelAccessor)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_(), LineCornerBlock::isConnected)))).m_61124_(YuushyaBlockStates.SHAPE, (Comparable)((Object)LineCornerBlock.getLineShape(res, (LevelAccessor)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_())));
    }

    @Override
    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        BlockState res = (BlockState)blockState.m_61124_(YuushyaBlockStates.POS_HORIZON, (Comparable)((Object)LineCornerBlock.getPositionOfFaceWithCorner(blockState, levelAccessor, blockPos, LineCornerBlock::isConnected)));
        return direction.m_122434_().m_122479_() ? (BlockState)res.m_61124_(YuushyaBlockStates.SHAPE, (Comparable)((Object)LineCornerBlock.getLineShape(res, levelAccessor, blockPos))) : res;
    }

    public static PositionHorizonState getPositionOfFaceWithCorner(BlockState state, LevelAccessor worldIn, BlockPos pos, BiPredicate<BlockState, BlockState> connected) {
        BlockState backBlock;
        Direction facingDirection = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        PositionHorizonState positionHorizonState = LineBlock.getPositionOfFace(state, worldIn, pos, connected);
        if (positionHorizonState != PositionHorizonState.NONE) {
            return positionHorizonState;
        }
        BlockState facingBlock = YuushyaUtils.getBlockState(worldIn.m_8055_(pos.m_121945_(facingDirection)), worldIn, pos.m_121945_(facingDirection));
        if (YuushyaBlockFactory.isTheSameBlock(state, facingBlock)) {
            Direction direction2 = (Direction)facingBlock.m_61143_((Property)BlockStateProperties.f_61374_);
            if (direction2 == facingDirection.m_122427_()) {
                return PositionHorizonState.LEFT;
            }
            if (direction2 == facingDirection.m_122428_()) {
                return PositionHorizonState.RIGHT;
            }
        }
        if (YuushyaBlockFactory.isTheSameBlock(state, backBlock = YuushyaUtils.getBlockState(worldIn.m_8055_(pos.m_121945_(facingDirection.m_122424_())), worldIn, pos.m_121945_(facingDirection.m_122424_())))) {
            Direction direction2 = (Direction)backBlock.m_61143_((Property)BlockStateProperties.f_61374_);
            if (direction2 == facingDirection.m_122427_()) {
                return PositionHorizonState.RIGHT;
            }
            if (direction2 == facingDirection.m_122428_()) {
                return PositionHorizonState.LEFT;
            }
        }
        return PositionHorizonState.NONE;
    }

    public static ShapeState getLineShape(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction direction3;
        Direction direction2;
        Direction facingDirection = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockState facingBlock = YuushyaUtils.getBlockState(level.m_8055_(pos.m_121945_(facingDirection)), level, pos.m_121945_(facingDirection));
        if (YuushyaBlockFactory.isTheSameBlock(state, facingBlock) && (direction2 = (Direction)facingBlock.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() && LineCornerBlock.canTakeShape(state, (BlockGetter)level, pos, direction2.m_122424_())) {
            return ShapeState.OUTER;
        }
        BlockState backBlock = YuushyaUtils.getBlockState(level.m_8055_(pos.m_121945_(facingDirection.m_122424_())), level, pos.m_121945_(facingDirection.m_122424_()));
        if (YuushyaBlockFactory.isTheSameBlock(state, backBlock) && (direction3 = (Direction)backBlock.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() && LineCornerBlock.canTakeShape(state, (BlockGetter)level, pos, direction3)) {
            return ShapeState.INNER;
        }
        return ShapeState.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState blockState = level.m_8055_(pos.m_121945_(face));
        return !YuushyaBlockFactory.isTheSameBlock(blockState, state) || blockState.m_61143_((Property)BlockStateProperties.f_61374_) != state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public static boolean isConnected(BlockState state1, BlockState curState) {
        return YuushyaBlockFactory.isTheSameFacing(state1, curState) || state1.m_61143_(YuushyaBlockStates.SHAPE) != ShapeState.STRAIGHT && ((Direction)state1.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_() != curState.m_61143_((Property)BlockStateProperties.f_61374_);
    }
}

