/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.atom.sweep.core;

import committee.nova.atom.sweep.Static;
import committee.nova.atom.sweep.core.model.ASItem;
import committee.nova.atom.sweep.core.model.ASMob;
import committee.nova.atom.sweep.init.config.ModConfig;
import committee.nova.atom.sweep.init.handler.SweepHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.vehicle.Boat;

public class Sweeper {
    public static final Sweeper INSTANCE = new Sweeper();
    private Timer timer;
    private TimerTask currentTask;

    private Sweeper() {
    }

    public void startSweep() {
        this.stopSweep();
        this.timer = new Timer();
        this.resetTimer();
    }

    public void stopSweep() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void resetTimer() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
        this.timer.purge();
        this.currentTask = new TimerTask(){

            @Override
            public void run() {
                if (Static.SERVER != null) {
                    Static.SERVER.execute(Sweeper.this::noticeSweep);
                }
                Sweeper.this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (Static.SERVER != null) {
                            Static.SERVER.execute(Sweeper.this::startSweepTick);
                        }
                    }
                }, (long)(ModConfig.INSTANCE.getCommon().getSweepNotify() - ModConfig.INSTANCE.getCommon().getSweepDiscount()) * 1000L);
            }
        };
        this.timer.schedule(this.currentTask, 0L, (long)ModConfig.INSTANCE.getCommon().getSweepPeriod() * 60L * 1000L);
    }

    public void startSweepTick() {
        SweepHandler.beginSweepCountDown();
    }

    public void noticeSweep() {
        Static.sendMessageToAllPlayers(ModConfig.INSTANCE.getCommon().getSweepNotice(), ModConfig.INSTANCE.getCommon().getSweepNotify());
    }

    public void sweep(MinecraftServer server) {
        int killItemCount = 0;
        int killLivingCount = 0;
        int killXpCount = 0;
        int killOtherCount = 0;
        Iterable worlds = server.m_129785_();
        for (ServerLevel world : worlds) {
            if (ModConfig.INSTANCE.getItem().isItemEntityCleanupEnable()) {
                killItemCount += this.cleanupItemEntity(world);
            }
            if (ModConfig.INSTANCE.getMob().isMobEntityCleanupEnable()) {
                if (ModConfig.INSTANCE.getMob().isAnimalEntitiesCleanupEnable()) {
                    killLivingCount += this.cleanupAnimalEntity(world);
                }
                if (ModConfig.INSTANCE.getMob().isMonsterEntitiesCleanupEnable()) {
                    killLivingCount += this.cleanupMonsterEntity(world);
                }
            }
            if (ModConfig.INSTANCE.getOther().isExperienceOrbEntityCleanupEnable()) {
                killXpCount += this.cleanupXpEntity(world);
            }
            killOtherCount += this.cleanOtherEntities(world);
        }
        Static.sendMessageToAllPlayers(server, ModConfig.INSTANCE.getCommon().getSweepNoticeComplete(), killItemCount, killLivingCount, killXpCount, killOtherCount);
    }

    public int cleanupItemEntity(ServerLevel world) {
        return this.cleanupEntity(world, entity -> entity instanceof ItemEntity, entity -> new ASItem((ItemEntity)entity).filtrate());
    }

    public int cleanupMonsterEntity(ServerLevel world) {
        return this.cleanupEntity(world, entity -> entity instanceof Monster, entity -> new ASMob((Mob)entity).filtrate());
    }

    public int cleanupAnimalEntity(ServerLevel world) {
        return this.cleanupEntity(world, entity -> entity instanceof Mob && !(entity instanceof Monster), entity -> new ASMob((Mob)entity).filtrate());
    }

    public int cleanupXpEntity(ServerLevel world) {
        return this.cleanupEntity(world, entity -> entity instanceof ExperienceOrb, entity -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cleanupEntity(ServerLevel world, Predicate<Entity> type, Predicate<Entity> additionalPredicate) {
        AtomicInteger amount = new AtomicInteger();
        List<Entity> entities = Collections.synchronizedList(new ArrayList());
        for (Entity e : world.m_8583_()) {
            entities.add(e);
        }
        try {
            List<Entity> list = entities;
            synchronized (list) {
                entities.stream().filter(Objects::nonNull).filter(entity -> entity.m_7770_() == null).filter(type).filter(additionalPredicate).forEach(entity -> {
                    if (ModConfig.INSTANCE.getMob().isExpOn()) {
                        entity.m_6074_();
                    } else {
                        entity.m_146870_();
                    }
                    if (entity instanceof ItemEntity) {
                        amount.getAndAdd(((ItemEntity)entity).m_32055_().m_41613_());
                    } else {
                        amount.getAndIncrement();
                    }
                });
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return amount.get();
    }

    public int cleanOtherEntities(ServerLevel world) {
        int amount = 0;
        if (ModConfig.INSTANCE.getOther().isFallingBlocksEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof FallingBlockEntity, entity -> true);
        }
        if (ModConfig.INSTANCE.getOther().isArrowEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof AbstractArrow, entity -> !(entity instanceof ThrownTrident));
        }
        if (ModConfig.INSTANCE.getOther().isTridentEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof ThrownTrident, entity -> true);
        }
        if (ModConfig.INSTANCE.getOther().isDamagingProjectileEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof AbstractHurtingProjectile, entity -> true);
        }
        if (ModConfig.INSTANCE.getOther().isShulkerBulletEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof ShulkerBullet, entity -> true);
        }
        if (ModConfig.INSTANCE.getOther().isFireworkRocketEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof FireworkRocketEntity, entity -> true);
        }
        if (ModConfig.INSTANCE.getOther().isItemFrameEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof ItemFrame, entity -> true);
        }
        if (ModConfig.INSTANCE.getOther().isPaintingEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof Painting, entity -> true);
        }
        if (ModConfig.INSTANCE.getOther().isBoatEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof Boat, entity -> true);
        }
        if (ModConfig.INSTANCE.getOther().isTNTEntityCleanupEnable()) {
            amount += this.cleanupEntity(world, entity -> entity instanceof PrimedTnt, entity -> true);
        }
        return amount;
    }
}

