/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.atom.sweep.common.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import committee.nova.atom.sweep.Static;
import committee.nova.atom.sweep.core.Sweeper;
import committee.nova.atom.sweep.init.config.ModConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SweepCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"atomsweep").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"items").executes(SweepCommand::itemsExe)).requires(context -> Static.cmdPermission(context, "atom.sweep.command.items", true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"monsters").executes(SweepCommand::monstersExe)).requires(context -> Static.cmdPermission(context, "atom.sweep.command.monsters", true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"animals").executes(SweepCommand::animalsExe)).requires(context -> Static.cmdPermission(context, "atom.sweep.command.animals", true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"others").executes(SweepCommand::othersExe)).requires(context -> Static.cmdPermission(context, "atom.sweep.command.others", true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"xps").executes(SweepCommand::xpsExe)).requires(context -> Static.cmdPermission(context, "atom.sweep.command.xps", true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"white").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"item").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").executes(SweepCommand::itemWhiteAdd)).requires(context -> context.m_6761_(2)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"del").executes(SweepCommand::itemWhiteDel)).requires(context -> context.m_6761_(2))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"entity").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"entity_name", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(SweepCommand::entityWhiteAdd))).requires(context -> context.m_6761_(2)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"del").then(Commands.m_82129_((String)"entity_name", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(SweepCommand::entityWhiteDel))).requires(context -> context.m_6761_(2))))));
    }

    private static int itemWhiteAdd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = player.m_21205_();
        if (ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()) != null) {
            ModConfig.INSTANCE.getItem().addItemEntitiesWhitelist(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString());
            ModConfig.INSTANCE.save();
            Static.sendMessage((Player)player, "message.cmd.item_white.add.success");
        } else {
            Static.sendMessage((Player)player, "message.cmd.item_white.add.fail");
        }
        return 1;
    }

    private static int itemWhiteDel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack itemStack = player.m_21205_();
        if (ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()) != null) {
            ModConfig.INSTANCE.getItem().delItemEntitiesWhitelist(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString());
            ModConfig.INSTANCE.save();
            Static.sendMessage((Player)player, "message.cmd.item_white.del.success");
        } else {
            Static.sendMessage((Player)player, "message.cmd.item_white.del.success");
        }
        return 1;
    }

    private static int entityWhiteAdd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ResourceLocation entityName = (ResourceLocation)context.getArgument("entity_name", ResourceLocation.class);
        if (ForgeRegistries.ENTITY_TYPES.getValue(entityName) != null) {
            ModConfig.INSTANCE.getMob().addMobEntitiesWhitelist(entityName.toString());
            ModConfig.INSTANCE.save();
            Static.sendMessage((Player)player, "message.cmd.entity_white.add.success");
        } else {
            Static.sendMessage((Player)player, "message.cmd.entity_white.add.fail");
        }
        return 1;
    }

    private static int entityWhiteDel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ResourceLocation entityName = (ResourceLocation)context.getArgument("entity_name", ResourceLocation.class);
        if (ForgeRegistries.ENTITY_TYPES.getValue(entityName) != null) {
            ModConfig.INSTANCE.getItem().delItemEntitiesWhitelist(entityName.toString());
            ModConfig.INSTANCE.save();
            Static.sendMessage((Player)player, "message.cmd.entity_white.del.success");
        } else {
            Static.sendMessage((Player)player, "message.cmd.entity_white.del.success");
        }
        return 1;
    }

    private static int itemsExe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        int killItemCount = Sweeper.INSTANCE.cleanupItemEntity(world);
        Static.sendMessageToAllPlayers(world.m_7654_(), ModConfig.INSTANCE.getCommon().getSweepNoticeComplete(), killItemCount, 0, 0, 0);
        return 1;
    }

    private static int monstersExe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        int killLivingCount = Sweeper.INSTANCE.cleanupMonsterEntity(world);
        Static.sendMessageToAllPlayers(world.m_7654_(), ModConfig.INSTANCE.getCommon().getSweepNoticeComplete(), 0, killLivingCount, 0, 0);
        return 1;
    }

    private static int animalsExe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        int killLivingCount = Sweeper.INSTANCE.cleanupAnimalEntity(world);
        Static.sendMessageToAllPlayers(world.m_7654_(), ModConfig.INSTANCE.getCommon().getSweepNoticeComplete(), 0, killLivingCount, 0, 0);
        return 1;
    }

    private static int xpsExe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        int killXpCount = Sweeper.INSTANCE.cleanupXpEntity(world);
        Static.sendMessageToAllPlayers(world.m_7654_(), ModConfig.INSTANCE.getCommon().getSweepNoticeComplete(), 0, 0, killXpCount, 0);
        return 1;
    }

    private static int othersExe(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        int killOtherCount = Sweeper.INSTANCE.cleanOtherEntities(world);
        Static.sendMessageToAllPlayers(world.m_7654_(), ModConfig.INSTANCE.getCommon().getSweepNoticeComplete(), 0, 0, 0, killOtherCount);
        return 1;
    }
}

