/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.atom.sweep;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.util.Tristate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Static {
    public static final String MOD_ID = "atomsweep";
    public static final Logger LOGGER = LogManager.getLogger((String)"atomsweep");
    public static Path CONFIG_FILE;
    public static Path ATOM_FOLDER;
    public static Path SWEEP_FOLDER;
    public static MinecraftServer SERVER;
    public static boolean isLuckPerms;

    public static void sendMessage(Player player, String message) {
        player.m_213846_((Component)Component.m_237115_((String)message));
    }

    public static void sendMessageToAllPlayers(Component message, boolean actionBar) {
        new Thread(() -> Optional.ofNullable(SERVER).ifPresent(server -> server.m_6846_().m_11314_().forEach(player -> player.m_5661_(message, actionBar)))).start();
    }

    public static void sendMessageToAllPlayers(MinecraftServer server1, String message, Object ... args) {
        new Thread(() -> Optional.ofNullable(server1).ifPresent(server -> server.m_6846_().m_240416_((Component)Component.m_237113_((String)MessageFormat.format(message, args)), true))).start();
    }

    public static void sendMessageToAllPlayers(String message, Object ... args) {
        new Thread(() -> Optional.ofNullable(SERVER).ifPresent(server -> server.m_6846_().m_240416_((Component)Component.m_237113_((String)MessageFormat.format(message, args)), true))).start();
    }

    public static Boolean hasPermission(ServerPlayer playerEntity, String permission) throws CommandSyntaxException {
        AtomicReference<Boolean> exist = new AtomicReference<Boolean>(false);
        ((CompletableFuture)LuckPermsProvider.get().getUserManager().loadUser(playerEntity.m_20148_()).thenApplyAsync(user -> {
            CachedPermissionData permissionData = user.getCachedData().getPermissionData(user.getQueryOptions());
            Tristate tristate = permissionData.checkPermission(permission);
            if (tristate.equals((Object)Tristate.UNDEFINED)) {
                return false;
            }
            return tristate.asBoolean();
        })).thenAcceptAsync(aBoolean -> {
            if (aBoolean.booleanValue()) {
                exist.set(true);
            }
        });
        return exist.get();
    }

    public static Boolean cmdPermission(CommandSourceStack source, String permission, boolean admin) {
        if (!isLuckPerms) {
            if (admin) {
                return source.m_6761_(2);
            }
            return true;
        }
        if (!(source.m_81373_() instanceof ServerPlayer)) {
            return source.m_6761_(2);
        }
        try {
            return Static.hasPermission(source.m_81375_(), permission);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    static {
        SERVER = ServerLifecycleHooks.getCurrentServer();
        isLuckPerms = false;
    }
}

